﻿using System;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.Links;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupMakeAppointment
{
    public class CreateResponseStep:FilterBase<MakeGroupAppointmentStateObject>
    {
        public override void Execute(MakeGroupAppointmentStateObject state)
        {
            if (!string.IsNullOrEmpty(state.VistaFakeResponseType))
            {
                state.MakeGroupAppointmentResponseMessage = new MakeGroupAppointmentResponseMessage
                {
                    ExceptionMessage = "*****THIS IS FAKE DATA. DATA NOT SENT TO Vista*****",
                    ExceptionOccured = false,
                    SerializedInstance = state.SerializedAppointment,
                    PatVistaAppointment = VistaSchedulingUtilities.MapGroupAppointmentEcToLob(Side.Patient, state, Logger.Instance),
                    ProVistaAppointment = VistaSchedulingUtilities.MapGroupAppointmentEcToLob(Side.Provider, state, Logger.Instance)
                };
            }
            else
            {
                state.MakeGroupAppointmentResponseMessage = state.ExceptionOccured
                  ? new MakeGroupAppointmentResponseMessage
                  {
                      ExceptionOccured = true,
                      ExceptionMessage = state.ExceptionMessage,
                      SerializedInstance = state.SerializedAppointment,
                      EcProcessingMs = state.EcProcessingTimeMs
                  }
                  : new MakeGroupAppointmentResponseMessage
                  {
                      ExceptionMessage = string.Empty,
                      ExceptionOccured = false,
                      SerializedInstance = state.SerializedAppointment,
                      PatVistaAppointment = VistaSchedulingUtilities.MapGroupAppointmentEcToLob(Side.Patient, state, Logger.Instance),
                      ProVistaAppointment = VistaSchedulingUtilities.MapGroupAppointmentEcToLob(Side.Provider, state, Logger.Instance),
                      EcProcessingMs = state.EcProcessingTimeMs
                  };
            }
        }
    }
}
